/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime.standard;

import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.runtime.binding.BindExternalFunction;
import team.unnamed.mocha.runtime.binding.Binding;
import team.unnamed.mocha.runtime.value.NumberValue;
import team.unnamed.mocha.runtime.value.ObjectProperty;
import team.unnamed.mocha.runtime.value.ObjectValue;
import team.unnamed.mocha.util.CaseInsensitiveStringHashMap;

@Binding(value={"math"})
@BindExternalFunction.Multiple(value={@BindExternalFunction(at=Math.class, name="abs", args={float.class}, pure=true), @BindExternalFunction(at=Math.class, name="max", args={float.class, float.class}, pure=true), @BindExternalFunction(at=Math.class, name="min", args={float.class, float.class}, pure=true), @BindExternalFunction(at=Math.class, name="round", args={float.class}, pure=true)})
public final class MochaMath
implements ObjectValue {
    @Binding(value={"pi"})
    public static final double PI = Math.PI;
    private static final double RADIAN = Math.toRadians(1.0);
    private static final Random RANDOM = new Random();
    private static final int DECIMAL_PART = 4;
    private final Map<String, ObjectProperty> entries = new CaseInsensitiveStringHashMap<ObjectProperty>();

    public MochaMath() {
        this.setFunction("abs", Math::abs);
        this.setFunction("acos", MochaMath::acos);
        this.setFunction("asin", MochaMath::asin);
        this.setFunction("atan", MochaMath::atan);
        this.setFunction("atan2", MochaMath::atan2);
        this.setFunction("ceil", MochaMath::ceil);
        this.setFunction("clamp", MochaMath::clamp);
        this.setFunction("cos", MochaMath::cos);
        this.setFunction("die_roll", MochaMath::dieRoll);
        this.setFunction("die_roll_integer", MochaMath::dieRollInteger);
        this.setFunction("exp", MochaMath::exp);
        this.setFunction("floor", MochaMath::floor);
        this.setFunction("hermite_blend", MochaMath::hermiteBlend);
        this.setFunction("lerp", MochaMath::lerp);
        this.setFunction("lerprotate", MochaMath::lerpRotate);
        this.setFunction("ln", MochaMath::log);
        this.setFunction("max", Math::max);
        this.setFunction("min", Math::min);
        this.setFunction("min_angle", MochaMath::minAngle);
        this.setFunction("mod", MochaMath::mod);
        this.entries.put("pi", ObjectProperty.property(NumberValue.of(Math.PI), true));
        this.setFunction("pow", MochaMath::pow);
        this.setFunction("random", MochaMath::random);
        this.setFunction("random_integer", MochaMath::randomInteger);
        this.setFunction("round", Math::round);
        this.setFunction("sin", MochaMath::sin);
        this.setFunction("sqrt", MochaMath::sqrt);
        this.setFunction("trunc", MochaMath::trunc);
        this.entries.replaceAll((key, property) -> ObjectProperty.property(property.value(), true));
    }

    @Binding(value={"ceil"}, pure=true)
    public static float ceil(float a) {
        return (float)StrictMath.ceil(a);
    }

    @Binding(value={"exp"}, pure=true)
    public static float exp(float a) {
        return (float)StrictMath.exp(a);
    }

    @Binding(value={"floor"}, pure=true)
    public static float floor(float a) {
        return (float)StrictMath.floor(a);
    }

    @Binding(value={"ln"}, pure=true)
    public static float log(float a) {
        return (float)StrictMath.log(a);
    }

    @Binding(value={"pow"}, pure=true)
    public static float pow(float a, float b) {
        return (float)StrictMath.pow(a, b);
    }

    @Binding(value={"sqrt"}, pure=true)
    public static float sqrt(float a) {
        return (float)StrictMath.sqrt(a);
    }

    private static float radify(float n) {
        return ((n + 180.0f) % 360.0f + 180.0f) % 360.0f;
    }

    @Binding(value={"acos"}, skipChecking=true, pure=true)
    public static float acos(float value) {
        return (float)NumberValue.normalize(Math.acos(value) / RADIAN);
    }

    @Binding(value={"asin"}, skipChecking=true, pure=true)
    public static float asin(float value) {
        return (float)NumberValue.normalize(Math.asin(value) / RADIAN);
    }

    @Binding(value={"atan"}, pure=true)
    public static float atan(float value) {
        return (float)(Math.atan(value) / RADIAN);
    }

    @Binding(value={"atan2"}, pure=true)
    public static float atan2(float y, float x) {
        return (float)(Math.atan2(y, x) / RADIAN);
    }

    @Binding(value={"clamp"}, pure=true)
    public static float clamp(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    @Binding(value={"cos"}, pure=true)
    public static float cos(float value) {
        return (float)Math.cos((double)value * RADIAN);
    }

    @Binding(value={"die_roll"})
    public static float dieRoll(float amount, float low, float high) {
        float result = 0.0f;
        int i = 0;
        while ((float)i < amount) {
            result += (float)RANDOM.nextInt((int)high) + low;
            ++i;
        }
        return result / 4.0f;
    }

    @Binding(value={"die_roll_integer"})
    public static float dieRollInteger(float amount, float low, float high) {
        int result = 0;
        int i = 0;
        while ((float)i < amount) {
            result += RANDOM.nextInt((int)low, (int)high);
            ++i;
        }
        return result;
    }

    @Binding(value={"hermite_blend"}, pure=true)
    public static float hermiteBlend(float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return 3.0f * t2 - 2.0f * t3;
    }

    @Binding(value={"lerp"}, pure=true)
    public static float lerp(float start, float end, float lerp) {
        return start + lerp * (end - start);
    }

    @Binding(value={"lerprotate"}, pure=true)
    public static float lerpRotate(float start, float end, float lerp) {
        float diff;
        if ((start = MochaMath.radify(start)) > (end = MochaMath.radify(end))) {
            float tmp = start;
            start = end;
            end = tmp;
        }
        if ((diff = end - start) > 180.0f) {
            return MochaMath.radify(end + lerp * (360.0f - diff));
        }
        return start + lerp * diff;
    }

    @Binding(value={"min_angle"}, pure=true)
    public static float minAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Binding(value={"mod"}, pure=true)
    public static float mod(float a, float b) {
        return a % b;
    }

    @Binding(value={"random"})
    public static float random(float min, float max) {
        return RANDOM.nextFloat(min, max);
    }

    @Binding(value={"random_integer"})
    public static int randomInteger(float min, float max) {
        return RANDOM.nextInt((int)min, (int)max);
    }

    @Binding(value={"sin"}, pure=true)
    public static float sin(float value) {
        return (float)Math.sin((double)value * RADIAN);
    }

    @Binding(value={"trunc"}, pure=true)
    public static float trunc(float value) {
        return value - value % 1.0f;
    }

    @Override
    @Nullable
    public ObjectProperty getProperty(@NotNull String name) {
        return this.entries.get(name);
    }
}

